/**********************************************************************
 *<
	FILE: skin.cpp

	DESCRIPTION:  A Skin object implementation

	CREATED BY: Peter Watje

	HISTORY: created May 28, 1997

 *>	Copyright (c) 1997, All Rights Reserved.
 **********************************************************************/
#include "prim.h" 
#include "splshape.h"
#include "iparamm.h"
// This is based on the simple spline object...
#include "..\..\include\simpspl.h"



#define SPLINETYPE 0									 
#define CIRCULAR 0


#define PBLOCK_REF		0
#define SKIN_REF		1
#define CONTROL_REF		101


#define MIN_RADIUS		float(0)
#define MAX_RADIUS		float( 1.0E30)

#define DEF_RADIUS		float(0.0)


#define SKIN_ID 0x16f73a7f, 0x5f0d3760



class SegmentType
	{
	public:
	int a,b;
	int used;
	};


class SplineListClass
	{
public:
	INode *SplineNode;
	};

class ControlListClass
	{
public:
	Control *c;
	};



class DonutObjCreateCallBack;

class DonutObject: public ShapeObject, public IParamArray {			   

	friend class DonutObjCreateCallBack;
	
	public:
		// Class vars
		static IParamMap *pmapParam;
		static IObjParam *ip;

		static DonutObject *editOb;


		IParamBlock *pblock;	// User's parameter block
		// Spline cache
		BezierShape shape;
		Interval ivalid;

		static int splinetype;
		static int circular;
		static int created;
		int NodeCount;

		HWND hWnd;

		Tab<Point3> VertList;
		Tab<SegmentType> SegmentList;

		SplineListClass SkinNode[100];
		ControlListClass SkinControl[100];
//		Tab<SplineListControlClass> SkinControl;


		int GetPointIndex(Point3 point);


//		static Point3 crtPos;		
//		static float crtRadius1, crtRadius2;
		
		void BuildSkin(TimeValue t,BezierShape& ashape); 
		void BuildShape(TimeValue t,BezierShape& ashape);
		
		Interval ObjectValidity(TimeValue t);


		DonutObject();
		~DonutObject();
		void DeleteThis() { delete this; }
		//  inherited virtual methods:

		CreateMouseCallBack* GetCreateMouseCallBack();
		void BeginEditParams( IObjParam *ip, ULONG flags,Animatable *prev);
		void EndEditParams( IObjParam *ip, ULONG flags,Animatable *next);
		TCHAR *GetObjectName() { return GetString(IDS_TH_DONUT); }
		void InitNodeName(TSTR& s) { s = GetString(IDS_TH_DONUT); }		
		Class_ID ClassID() { return Class_ID(SKIN_ID); }  
		void GetClassName(TSTR& s) { s = TSTR(GetString(IDS_TH_DONUT)); }
		RefTargetHandle Clone(RemapDir& remap = NoRemap());
		BOOL ValidForDisplay(TimeValue t);

		ParamDimension *GetParameterDim(int pbIndex);
		TSTR GetParameterName(int pbIndex);

		void InvalidateUI() { if (pmapParam) pmapParam->Invalidate(); }



	// ReferenceMaker methods:

		int NumSubs() {return 1;}
		Animatable* SubAnim(int i) {return pblock;}
		TSTR SubAnimName(int i) {return _T("");}

		int NumRefs() {return 1+100+100;}
		RefTargetHandle GetReference(int i);
		void SetReference(int i, RefTargetHandle rtarg);
		RefResult NotifyRefChanged( Interval changeInt,RefTargetHandle hTarget, 
		   PartID& partID, RefMessage message);



		int NumberOfCurves();
		BOOL CurveClosed(TimeValue t, int curve);

		Point3 InterpCurve3D(TimeValue t, int curve, float param, int ptype=PARAM_SIMPLE);
		Point3 TangentCurve3D(TimeValue t, int curve, float param, int ptype=PARAM_SIMPLE);
		float LengthOfCurve(TimeValue t, int curve);
		int NumberOfPieces(TimeValue t, int curve);
		Point3 InterpPiece3D(TimeValue t, int curve, int piece, float param, int ptype=PARAM_SIMPLE);
		Point3 TangentPiece3D(TimeValue t, int curve, int piece, float param, int ptype=PARAM_SIMPLE);

		ShapeHierarchy &OrganizeCurves(TimeValue t, ShapeHierarchy *hier=NULL);	// Ready for lofting, extrusion, etc.
		void MakePolyShape(TimeValue t, PolyShape &shape, int steps = PSHAPE_BUILTIN_STEPS, BOOL optimize = FALSE);

		int MakeCap(TimeValue t, MeshCapInfo &capInfo, int capType);	// Makes a cap out of the shape
		int MakeCap(TimeValue t, PatchCapInfo &capInfo);

		void ShapeInvalid() { ivalid.SetEmpty(); }
		void UpdateShape(TimeValue t);


		
		ObjectState Eval(TimeValue time);
		int CanConvertToType(Class_ID obtype);
		Object* ConvertToType(TimeValue t, Class_ID obtype);
		void GetCollapseTypes(Tab<Class_ID> &clist,Tab<TSTR*> &nlist);

		void BuildMesh(TimeValue t, Mesh &mesh);
		
		// From ShapeObject
		ObjectHandle CreateTriObjRep(TimeValue t);  // for rendering, also for deformation		
		void GetWorldBoundBox(TimeValue t, INode* inode, ViewExp* vpt, Box3& box );
		void GetLocalBoundBox(TimeValue t, INode* inode, ViewExp* vxt, Box3& box );
		void GetDeformBBox(TimeValue t, Box3& box, Matrix3 *tm, BOOL useSel );
		int NumberOfVertices(TimeValue t, int curve);



		// From BaseObject
		int HitTest(TimeValue t, INode* inode, int type, int crossing, int flags, IPoint2 *p, ViewExp *vpt);
		void Snap(TimeValue t, INode* inode, SnapInfo *snap, IPoint2 *p, ViewExp *vpt);
		int Display(TimeValue t, INode* inode, ViewExp *vpt, int flags);
		void FreeCaches(); 
	};				

//------------------------------------------------------

class DonutObjClassDesc:public ClassDesc {
	public:
	int 			IsPublic() { return 1; }
	void *			Create(BOOL loading = FALSE) { 
					return new DonutObject();  }
	const TCHAR *	ClassName() { return GetString(IDS_TH_DONUT); }
	SClass_ID		SuperClassID() { return SHAPE_CLASS_ID; }
   	Class_ID		ClassID() { return Class_ID(SKIN_ID); }
	const TCHAR* 	Category() { return GetString(IDS_TH_SPLINES);  }
	void			ResetClassParams(BOOL fileReset);
	};

static DonutObjClassDesc donutObjDesc;

ClassDesc* GetDonutDesc() { return &donutObjDesc; }

// in prim.cpp  - The dll instance handle
extern HINSTANCE hInstance;

// class variable for donut class.
IParamMap *DonutObject::pmapParam  = NULL;
IObjParam *DonutObject::ip         = NULL;
int	 DonutObject::splinetype = SPLINETYPE;

int	 DonutObject::created = 0;


DonutObject *DonutObject::editOb = NULL;

void DonutObjClassDesc::ResetClassParams(BOOL fileReset)
	{
	}



// Vector length for unit circle
#define CIRCLE_VECTOR_LENGTH 0.5517861843f



//--- Parameter map/block descriptors -------------------------------

static int outputIDs[] = {IDC_RADIO1,IDC_RADIO2,IDC_RADIO3,IDC_RADIO4};


#define PB_SPLINETYPE	0


//
//
// Parameters


static ParamUIDesc descParam[] = {
	// Spline type
	ParamUIDesc(PB_SPLINETYPE,TYPE_RADIO,outputIDs,4),


	};
#define PARAMDESC_LENGTH 1


static ParamBlockDescID descVer0[] = {
	{ TYPE_FLOAT, NULL, TRUE, 0 },
	{ TYPE_INT, NULL, TRUE, 1 },
	{ TYPE_INT, NULL, FALSE, 2 },
	{ TYPE_INT, NULL, FALSE, 3 } };

static ParamBlockDescID descVer1[] = {
	{ TYPE_FLOAT, NULL, TRUE, 0 },
	{ TYPE_INT, NULL, TRUE, 1 },
	{ TYPE_INT, NULL, FALSE, 2 },
	{ TYPE_INT, NULL, FALSE, 3 },
	{ TYPE_INT, NULL, FALSE, 4 } };

static ParamBlockDescID descVer2[] = {
	{ TYPE_FLOAT, NULL, TRUE, 0 },
	{ TYPE_INT, NULL, TRUE, 1 },
	{ TYPE_INT, NULL, FALSE, 2 },
	{ TYPE_INT, NULL, FALSE, 3 },
	{ TYPE_INT, NULL, FALSE, 4 },
	{ TYPE_INT, NULL, FALSE, 5 } };

static ParamBlockDescID descVer3[] = {
	{ TYPE_INT, NULL, TRUE, 0 },
	 };

#define PBLOCK_LENGTH	1

// Array of old versions
static ParamVersionDesc versions[] = {
	ParamVersionDesc(descVer0,4,3),
	ParamVersionDesc(descVer1,5,4),	
	ParamVersionDesc(descVer2,6,5)	
	};
#define NUM_OLDVERSIONS	3

// Current version
#define CURRENT_VERSION	6
static ParamVersionDesc curVersion(descVer3,PBLOCK_LENGTH,CURRENT_VERSION);


/*
static ParamUIDesc descParam[] = {
	// Radius 1
	ParamUIDesc(
		PB_RADIUS1,
		EDITTYPE_UNIVERSE,
		IDC_RADIUS1,IDC_RAD1SPINNER,
		MIN_RADIUS,MAX_RADIUS,
		SPIN_AUTOSCALE),	
	
	// Radius 2
	ParamUIDesc(
		PB_RADIUS2,
		EDITTYPE_UNIVERSE,
		IDC_RADIUS2,IDC_RAD2SPINNER,
		MIN_RADIUS,MAX_RADIUS,
		SPIN_AUTOSCALE)	
	
	};
#define PARAMDESC_LENGTH 2


static ParamBlockDescID descVer0[] = {
	{ TYPE_FLOAT, NULL, TRUE, 0 },		
	{ TYPE_FLOAT, NULL, TRUE, 1 } };
#define PBLOCK_LENGTH	2

// Array of old versions
static ParamVersionDesc versions[] = {
	ParamVersionDesc(descVer0,3,0)			// This is a dummy entry!!!
	};
#define NUM_OLDVERSIONS	0	// No old ones yet!

// Current version
#define CURRENT_VERSION	0
static ParamVersionDesc curVersion(descVer0,PBLOCK_LENGTH,CURRENT_VERSION);
*/



//This handles the output of particle info
//Hit Dialog

class DumpHitDialog : public HitByNameDlgCallback {
public:
	DonutObject *eo;
	DumpHitDialog(DonutObject *e) {eo=e;};
	TCHAR *dialogTitle() {return _T("Select skin sections");};
	TCHAR *buttonText() {return _T("Select");};
	BOOL singleSelect() {return FALSE;};
	BOOL useProc() {return TRUE;};
	int filter(INode *node);
	void proc(INodeTab &nodeTab);
	};

void DumpHitDialog::proc(INodeTab &nodeTab)

{

//?

for (int i=0;i<nodeTab.Count();i++)
	{
	SplineListClass t;


	t.SplineNode = nodeTab[i];
	for (int j=0;j<100;j++)
		{
		if (eo->SkinNode[j].SplineNode == NULL)
			{
			eo->ReplaceReference(SKIN_REF+j,nodeTab[i]);

			TCHAR title[200];
			_tcscpy(title,nodeTab[i]->GetName());

			SendMessage(GetDlgItem(eo->hWnd,IDC_LIST1),
				LB_ADDSTRING,0,(LPARAM)(TCHAR*)title);
			eo->NodeCount++;
			j=101;
			}

		}

	}
/*
ModContextList mcList;
INodeTab nodes;
eo->ip->GetModContexts(mcList,nodes);
if ( (nodes.Count()>0) && 
	 (nodeTab.Count()>0)  ) {
	Matrix3 tm;
 	tm = nodeTab[0]->GetObjectTM(0);
	nodes[0]->SetNodeTM(0, tm);
//	ourTM = nodes[0]->GetObjectTM(ip->GetTime());
	}
*/
eo->ShapeInvalid();

eo->NotifyDependents(FOREVER, TOPO_CHANNEL, REFMSG_CHANGE);
											
// po->ObjectNode = nodeTab[0];
}





int DumpHitDialog::filter(INode *node)

{
//	Class_ID c,d;

	node->BeginDependencyTest();
	eo->NotifyDependents(FOREVER,0,REFMSG_TEST_DEPENDENCY);
	if (node->EndDependencyTest()) 
		{		
		return FALSE;
		} 

	for (int i=0;i<100;i++)
		{	
		if (node == eo->SkinNode[i].SplineNode)
			return FALSE;
		}
	ObjectState os = node->EvalWorldState(eo->ip->GetTime());
//	c = os.obj->ClassID();
//	d = MGRAPH_CLASSID;
	if (os.obj->SuperClassID()==SHAPE_CLASS_ID) 

//	return (os.obj->ClassID()==MGRAPH_CLASSID);
	return TRUE;
	else return FALSE;

}


//-- SkinDlgProc ------------------------------------------------

class SkinDlgProc : public ParamMapUserDlgProc {
	public:
		DonutObject *po;
		HWND TempHWND;

		SkinDlgProc(DonutObject *p) {
			po=p;
			}
		BOOL DlgProc(TimeValue t,IParamMap *map,HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam);
		void DeleteThis() {
			delete this;
			}
		void DumpRPS(HWND hWnd);
		void RemoveNode(HWND hWnd);
		void UpNode(HWND hWnd);
		void DownNode(HWND hWnd);

	};

void SkinDlgProc::DumpRPS(HWND hWnd)
	{
//pick nodes to apply motion to 
	po->ip->DoHitByNameDialog(new DumpHitDialog(po));
	}

void SkinDlgProc::RemoveNode(HWND hWnd)
	{
//pick nodes to apply motion to 
//Get selection
	int sel;
	sel = SendMessage(GetDlgItem(po->hWnd,IDC_LIST1),
				LB_GETCURSEL ,0,0);
	if (sel>=0)
		{
		SendMessage(GetDlgItem(po->hWnd,IDC_LIST1),
				LB_DELETESTRING  ,(WPARAM) sel,0);


//delete ref
		for (int j=sel;j<po->NodeCount;j++)
			{
			po->ReplaceReference(SKIN_REF+j,po->SkinNode[j+1].SplineNode);
			}
		po->SkinNode[po->NodeCount-1].SplineNode = NULL;
		po->NodeCount--;

		}
	po->ShapeInvalid();

	po->NotifyDependents(FOREVER, TOPO_CHANNEL, REFMSG_CHANGE);

	}




void SkinDlgProc::UpNode(HWND hWnd)
	{
//pick nodes to apply motion to 
//Get selection
	int sel;
	sel = SendMessage(GetDlgItem(po->hWnd,IDC_LIST1),
				LB_GETCURSEL ,0,0);
	if (sel>0)
		{
		INode *Temp;
		
		Temp = po->SkinNode[sel-1].SplineNode;
		TCHAR title[200];
		_tcscpy(title,po->SkinNode[sel-1].SplineNode->GetName());

		po->ReplaceReference(SKIN_REF+sel-1,po->SkinNode[sel].SplineNode);
		po->ReplaceReference(SKIN_REF+sel,Temp);




		SendMessage(GetDlgItem(po->hWnd,IDC_LIST1),
			LB_DELETESTRING,sel-1,0);

		SendMessage(GetDlgItem(po->hWnd,IDC_LIST1),
			LB_INSERTSTRING,sel,(LPARAM)(TCHAR*)title);


		SendMessage(GetDlgItem(po->hWnd,IDC_LIST1),
			LB_SETCURSEL,(WPARAM) sel-1,0);

		}

	po->ShapeInvalid();

	po->NotifyDependents(FOREVER, TOPO_CHANNEL, REFMSG_CHANGE);

	}



void SkinDlgProc::DownNode(HWND hWnd)
	{
//pick nodes to apply motion to 
//Get selection
	int sel;
	sel = SendMessage(GetDlgItem(po->hWnd,IDC_LIST1),
				LB_GETCURSEL ,0,0);
	if ((sel+1)<po->NodeCount)
		{
		INode *Temp;
		

		Temp = po->SkinNode[sel+1].SplineNode;
		TCHAR title[200];
		_tcscpy(title,po->SkinNode[sel+1].SplineNode->GetName());

		po->ReplaceReference(SKIN_REF+sel+1,po->SkinNode[sel].SplineNode);
		po->ReplaceReference(SKIN_REF+sel,Temp);




		SendMessage(GetDlgItem(po->hWnd,IDC_LIST1),
			LB_DELETESTRING,sel+1,0);

		SendMessage(GetDlgItem(po->hWnd,IDC_LIST1),
			LB_INSERTSTRING,sel,(LPARAM)(TCHAR*)title);


		SendMessage(GetDlgItem(po->hWnd,IDC_LIST1),
			LB_SETCURSEL,(WPARAM) sel+1,0);

		}

	po->ShapeInvalid();

	po->NotifyDependents(FOREVER, TOPO_CHANNEL, REFMSG_CHANGE);

	}




BOOL SkinDlgProc::DlgProc(
		TimeValue t,IParamMap *map,HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam)
	{
	switch (msg) {
		case WM_INITDIALOG:
			{
			po->hWnd = hWnd;
			
			po->NodeCount = 0;

			TCHAR title[200];
			int i;
			for (i=0;i<100;i++)
				{
				if (po->SkinNode[i].SplineNode!=NULL)
					{
					_tcscpy(title,po->SkinNode[i].SplineNode->GetName());

					SendMessage(GetDlgItem(po->hWnd,IDC_LIST1),
						LB_ADDSTRING,0,(LPARAM)(TCHAR*)title);
					po->NodeCount++;
					}
				}
			if (po->created)
				{
				EnableWindow(GetDlgItem(hWnd,IDC_ADD),TRUE);
				EnableWindow(GetDlgItem(hWnd,IDC_REMOVE),TRUE);
				EnableWindow(GetDlgItem(hWnd,IDC_UP),TRUE);
				EnableWindow(GetDlgItem(hWnd,IDC_DOWN),TRUE);
				}
				else {
				EnableWindow(GetDlgItem(hWnd,IDC_ADD),FALSE);
				EnableWindow(GetDlgItem(hWnd,IDC_REMOVE),FALSE);
				EnableWindow(GetDlgItem(hWnd,IDC_UP),FALSE);
				EnableWindow(GetDlgItem(hWnd,IDC_DOWN),FALSE);
				}
			


//add names here
			break;			
			}
		case WM_COMMAND:
			switch (LOWORD(wParam)) {
				case IDC_ADD :
					DumpRPS(hWnd);
					break;
				case IDC_REMOVE :
					RemoveNode(hWnd);
					break;
				case IDC_UP :
					UpNode(hWnd);
					break;
				case IDC_DOWN :
					DownNode(hWnd);
					break;
				case IDC_HELPBUTTON:
					ShellExecute(GetCOREInterface()->GetMAXHWnd(), "open", "iexplore.exe", "www.max3dstuff.com/max4/crossSectionObject/help.html", NULL, SW_SHOWNORMAL);
					break;

				}
			break;	
		}
	return FALSE;
	}






void DonutObject::BeginEditParams( IObjParam *ip, ULONG flags,Animatable *prev )
	{


	ShapeObject::BeginEditParams(ip, flags, prev);

	editOb = this;
	this->ip = ip;

	if (flags&BEGIN_EDIT_CREATE) {
		created = FALSE;
	} else { created = TRUE; }


	if ( pmapParam) {
		
		// Left over from last donut ceated
		pmapParam->SetParamBlock(pblock);
	} else {
		
		// Gotta make a new one.

		pmapParam = CreateCPParamMap(
			descParam,PARAMDESC_LENGTH,
			pblock,
			ip,
			hInstance,
			MAKEINTRESOURCE(IDD_DONUTPARAM2),
			GetString(IDS_TH_PARAMETERS),
			0);

		
		}

	pmapParam->SetUserDlgProc(new SkinDlgProc(this));

	}
		
void DonutObject::EndEditParams( IObjParam *ip,ULONG flags,Animatable *next )
	{
	ShapeObject::EndEditParams(ip,flags,next);
	this->ip = NULL;
	editOb = NULL;
	if (flags&END_EDIT_REMOVEUI ) {
		DestroyCPParamMap(pmapParam);
		pmapParam  = NULL;
		}

	// Save these values in class variables so the next object created will inherit them.
	}


RefTargetHandle DonutObject::GetReference(int i) 
	{
	switch (i) {
		case PBLOCK_REF:	return pblock;	
//		case SKIN_REF :		return SkinNode[0].SplineNode;
		default : {
				if (i<100)
					return SkinNode[i-1].SplineNode;
					else return 
						SkinControl[i-101].c;
				}
		}
	}

void DonutObject::SetReference(int i, RefTargetHandle rtarg) 
	{	
	switch (i) {
		case PBLOCK_REF: pblock = (IParamBlock*)rtarg; break;
		default : {
				if (i<100)
					SkinNode[i-1].SplineNode = (INode*)rtarg;
				else 
					SkinControl[i-101].c = (Control*)rtarg;
				break;
				}

		}
	}


RefResult DonutObject::NotifyRefChanged(
		Interval changeInt, RefTargetHandle hTarget,
		PartID& partID,  RefMessage message) 

	{

	// If this isn't one of our references, pass it on to the ShapeObject...
	switch (message) {
		case REFMSG_CHANGE:
			ShapeInvalid();
			ShapeObject::InvalidateGeomCache();
			if (editOb==this) {
				InvalidateUI();
				}
			break;

		case REFMSG_GET_PARAM_DIM: {
			GetParamDim *gpd = (GetParamDim*)partID;
			gpd->dim = GetParameterDim(gpd->index);			
			return REF_STOP; 
			}

		case REFMSG_GET_PARAM_NAME: {
			GetParamName *gpn = (GetParamName*)partID;
			gpn->name = GetParameterName(gpn->index);			
			return REF_STOP; 
			}

		case REFMSG_TARGET_DELETED: {
			if (hTarget==pblock) {
				pblock = NULL;					
				}
			else {
				for (int j = 0; j < 100;j++)
					{
					if (hTarget==SkinNode[j].SplineNode) {
						SkinNode[j].SplineNode=NULL;
						}
					if (hTarget==SkinControl[j].c) {
						SkinControl[j].c=NULL;
						}
					}
				}

			break;
			}
				
		}
	return REF_SUCCEED;
	}





int DonutObject::GetPointIndex(Point3 point)
{
for (int i=0;i<VertList.Count();i++)
	{
	if (VertList[i] == point)
		return i;
	}
return 0;
};


void DonutObject::BuildSkin(TimeValue t,BezierShape& ashape) {






//SplineShape *shape = (SplineShape *)os->obj;

//Add extra spline info here

//object inv tm

Matrix3 tm;
Matrix3 invtm;
Matrix3 SectionTM;
 

if (SkinNode[0].SplineNode != NULL)
	{
	tm    = SkinNode[0].SplineNode->GetObjTMAfterWSM(t);
//	tm = *mc.tm;
	invtm = Inverse(tm);

	for (int ac=0;ac < 100;ac++)
		{
		if (SkinNode[ac].SplineNode != NULL)
		{
		Spline3D* NewSpline;
//get spline tm
		NewSpline = ashape.NewSpline(KTYPE_CORNER,KTYPE_BEZIER);



//get spline 
		BezierShape Section;
		ObjectState os;
		os = SkinNode[ac].SplineNode->EvalWorldState(t);


		ShapeObject *shape = (ShapeObject *) os.obj;
// If the shape can convert itself to a BezierShape, have it do so!


		if(shape->CanMakeBezier())
			shape->MakeBezier(t, Section);
		else {
			PolyShape pShape;
			shape->MakePolyShape(t, pShape);
			Section = pShape;	// UGH -- Convert it from a PolyShape -- not good!
			}






		Spline3D *SectionSpline = Section.GetSpline(0);

		if (SectionSpline == NULL) return;

		Point3 knot,ivec,ovec;
		int closed;
		int knottype;
		closed = SectionSpline->Closed();
		SectionTM = SkinNode[ac].SplineNode->GetObjTMAfterWSM(t);
		for (int kcount = 0;kcount<SectionSpline->KnotCount();kcount++)
			{
//get knot type
			knot = SectionSpline->GetKnotPoint(kcount);
//get invec 
			ivec = SectionSpline->GetInVec(kcount);
//get outvec
			ovec = SectionSpline->GetOutVec(kcount);
//get knot type
			knottype = SectionSpline->GetKnotType(kcount);

//transform to world
			knot = knot * SectionTM;
			ivec = ivec * SectionTM;
			ovec = ovec * SectionTM;

			knot = knot * invtm;
			ivec = ivec * invtm;
			ovec = ovec * invtm;

			SplineKnot kn(knottype,LTYPE_CURVE,knot,ivec,ovec);


			NewSpline->AddKnot(kn);
			}
		if (closed)
			  NewSpline->SetClosed();
		NewSpline->ComputeBezPoints();
		}
	}

int polys = ashape.splineCount;
int poly;
int i,j;
BOOL anyClosed = FALSE;



#ifdef DEBUG 
	DebugPrint("Enter Cross Section Modifier Beta 1.0 Digimation Evaluation Copy\n");
DebugPrint("Building vert list\n");
#endif

int SameCount = 1,ct;
int AClosed, BClosed;
int KType,K;

if (polys >1)
	{

	pblock->GetValue(PB_SPLINETYPE,t,K,FOREVER);
	KType = KTYPE_CORNER;

	if (K == 0)
		KType = KTYPE_CORNER;
	else if (K == 1)
		KType = KTYPE_AUTO;
	else if (K == 2)
		KType = KTYPE_BEZIER;
	else if (K == 3)
		KType = KTYPE_BEZIER_CORNER;




	ct = ashape.splines[0]->KnotCount();
	AClosed = ashape.splines[0]->Closed();
	for (i=1;i< polys;i++)
		{
		if (ct != ashape.splines[i]->KnotCount())
			{
			SameCount = -1;
			continue;
			}
		BClosed = ashape.splines[i]->Closed();
		if (BClosed != AClosed)
			{
			SameCount = -1;
			continue;
			}
		}

	if (SameCount==1)
		{
		for (i=0;i<ashape.splines[0]->KnotCount();i++)
			{
			Spline3D *Addspline = ashape.NewSpline();
//add verts
			for(poly = 0; poly < polys; ++poly) {
				Spline3D *spline = ashape.splines[poly];
				if(spline->Closed())
					anyClosed = TRUE;
					else anyClosed = FALSE;

	// Now add all the necessary points

//Next points or knots are added to the spline by calling AddKnot(). This allows you to add different types of knots and line segments.
				Point3 p(0.0f, 0.0f, 0.0f);
				p = spline->GetKnotPoint(i);
//		spline->KnotPoint(i)
				Addspline->AddKnot(SplineKnot(KTYPE_AUTO,LTYPE_CURVE,
					spline->GetKnotPoint(i),p,p));
				}
			Addspline->ComputeBezPoints();
			for (poly=0;poly<Addspline->KnotCount();poly++)
				Addspline->SetKnotType(poly,KType);
			Addspline->ComputeBezPoints();
			Addspline->SetOpen();

			}
		}
	else
		{
		Point3 temp;

		VertList.ZeroCount();
		SegmentList.ZeroCount();


//build vert list
		for(poly = 0; poly < polys; ++poly) 
			{
			Spline3D *spline = ashape.splines[poly];

			for (i=0;i<ashape.splines[poly]->KnotCount();i++)
				{
				temp = spline->GetKnotPoint(i);
				VertList.Append(1,&temp,1);
				}
			}

//build segment list
		for(poly = 0; poly < polys-1; ++poly) 
			{

//get spline 

			Spline3D *splineA = ashape.splines[poly];


			Spline3D *splineB = ashape.splines[poly+1];


			int ACount, BCount,AV,BV;
			SegmentType temp;
			ACount = ashape.splines[poly]->KnotCount();
			BCount = ashape.splines[poly+1]->KnotCount();

			AClosed = ashape.splines[poly]->Closed();
			BClosed = ashape.splines[poly+1]->Closed();


			if (ACount == BCount)
				{
				if (AClosed == BClosed)
					{
					for (j=0;j<ACount;j++)
						{
						temp.a = GetPointIndex(splineA->GetKnotPoint(j));
						temp.b = GetPointIndex(splineB->GetKnotPoint(j));
						temp.used = 0;

					
						SegmentList.Append(1,&temp,1);
						}
					}
				else if (AClosed)
					{
					for (j=0;j<ACount;j++)
						{
						temp.a = GetPointIndex(splineA->GetKnotPoint(j));
						temp.b = GetPointIndex(splineB->GetKnotPoint(j));
						temp.used = 0;


					
						SegmentList.Append(1,&temp,1);
						}

					temp.a = GetPointIndex(splineA->GetKnotPoint(0));
					temp.b = GetPointIndex(splineB->GetKnotPoint(BCount-1));
					temp.used = 0;


					
					SegmentList.Append(1,&temp,1);

					}
				else
					{
					for (j=0;j<ACount;j++)
						{
						temp.a = GetPointIndex(splineA->GetKnotPoint(j));
						temp.b = GetPointIndex(splineB->GetKnotPoint(j));
						temp.used = 0;


					
						SegmentList.Append(1,&temp,1);
						}

					temp.a = GetPointIndex(splineA->GetKnotPoint(BCount-1));
					temp.b = GetPointIndex(splineB->GetKnotPoint(0));
					temp.used = 0;


					
					SegmentList.Append(1,&temp,1);

					}


				}
			else if (ACount < BCount)
				{
				float APer,BPer,ALength,BLength;
				Tab<float> PerListA;
				Tab<float> PerListB;
				int k;
				Point3 a;
				float Dist1,Dist2;

				PerListA.ZeroCount();
				PerListB.ZeroCount();

				ALength = splineA->SplineLength();
				BLength = splineB->SplineLength();

				float CLength = 0.0f;
				float t;

				for (j=0;j<ACount;j++)
					{
					t = CLength/ALength;
					if (t >1.0f) t = 1.0f;
					PerListA.Append(1,&t,1);
					t = 0.0f;
					for (k=0;k<10;k++)
						{
						t += 0.1f;
						CLength += Length(splineA->InterpBezier3D(j, t-0.1f)-
										  splineA->InterpBezier3D(j, t));
						}
					}


				CLength = 0.0f;
				for (j=0;j<BCount;j++)
					{
					t = CLength/BLength;
					if (t >1.0f) t = 1.0f;
					PerListB.Append(1,&t,1);
					t = 0.0f;
					for (k=0;k<10;k++)
						{
						t += 0.1f;
						CLength += Length(splineB->InterpBezier3D(j, t-0.1f)-
										  splineB->InterpBezier3D(j, t));
						}
					}

				if (AClosed!=BClosed)
					{
					if (AClosed)
						{
						t = 1.0f;
						PerListA.Append(1,&t,1);
						ACount++;
						}
					else
						{
						t = 1.0f;
						PerListB.Append(1,&t,1);
						BCount++;
						}

					}

				


				AV = 0;

				for (j=0;j<BCount;j++)
					{
//get a and b percent
					APer = PerListA[AV];
					BPer = PerListB[j];
					if ((AClosed!=BClosed)&&(AClosed)&&(AV==(ACount-1)))
						temp.a = GetPointIndex(splineA->GetKnotPoint(0));
						else temp.a = GetPointIndex(splineA->GetKnotPoint(AV));
					if ((AClosed!=BClosed)&&(BClosed)&&(j==(BCount-1)))
						temp.b = GetPointIndex(splineB->GetKnotPoint(0));
					else temp.b = GetPointIndex(splineB->GetKnotPoint(j));
					temp.used = 0;


					SegmentList.Append(1,&temp,1);
//check if ned to advance to bnext vertex

					if ((AV < (ACount-1))  && (j != (BCount-1)) )
						{
						Dist1 = (float)fabs(PerListB[j+1]-PerListA[AV]);
						Dist2 = (float)fabs(PerListB[j+1]-PerListA[AV+1]);
						if ( Dist2<Dist1 )
							AV++;
						}

					}




				}
			else
				{
				float APer,BPer,ALength,BLength;
				Tab<float> PerListA;
				Tab<float> PerListB;
				int k;
				Point3 a;
				float Dist1,Dist2;

				PerListA.ZeroCount();
				PerListB.ZeroCount();

				ALength = splineA->SplineLength();
				BLength = splineB->SplineLength();

				float CLength = 0.0f;
				float t;

				for (j=0;j<ACount;j++)
					{
					t = CLength/ALength;
					if (t >1.0f) t = 1.0f;
					PerListA.Append(1,&t,1);
					t = 0.0f;
					for (k=0;k<10;k++)
						{
						t += 0.1f;
						CLength += Length(splineA->InterpBezier3D(j, t-0.1f)-
										  splineA->InterpBezier3D(j, t));
						}
					}

				CLength = 0.0f;
				for (j=0;j<BCount;j++)
					{
					t = CLength/BLength;
					if (t >1.0f) t = 1.0f;
					PerListB.Append(1,&t,1);
					t = 0.0f;
					for (k=0;k<10;k++)
						{
						t += 0.1f;
						CLength += Length(splineB->InterpBezier3D(j, t-0.1f)-
										  splineB->InterpBezier3D(j, t));
						}
					}

				
				if (AClosed!=BClosed)
					{
					if (AClosed)
						{
						t = 1.0f;
						PerListA.Append(1,&t,1);
						ACount++;
						}
					else
						{
						t = 1.0f;
						PerListB.Append(1,&t,1);
						BCount++;
						}

					}

				



				BV = 0;

				for (j=0;j<ACount;j++)
					{
//get a and b percent
					APer = PerListA[j];
					BPer = PerListB[BV];
					if ((AClosed!=BClosed)&&(AClosed)&&(j==(ACount-1)))
						temp.a = GetPointIndex(splineA->GetKnotPoint(0));
						else temp.a = GetPointIndex(splineA->GetKnotPoint(j));
					if ((AClosed!=BClosed)&&(BClosed)&&(BV==(BCount-1)))
						temp.b = GetPointIndex(splineB->GetKnotPoint(0));
					else temp.b = GetPointIndex(splineB->GetKnotPoint(BV));
					temp.used = 0;



					SegmentList.Append(1,&temp,1);
//check if ned to advance to bnext vertex
					if ((BV < (BCount-1)) && (j != (ACount-1)))
						{
						Dist1 = (float)fabs(PerListA[j+1]-PerListB[BV]);
						Dist2 = (float)fabs(PerListA[j+1]-PerListB[BV+1]);
						if ( Dist2<Dist1 )
							BV++;
						}

					}





				}


			}

//build splines
		SegmentType tmp;
		for (j=0;j<SegmentList.Count();j++)
			{
			if (!SegmentList[j].used)
				{
//build spline
				Spline3D *Addspline = ashape.NewSpline();
//add verts
// Now add all the necessary points
				int done = 0;
				int found = 0;
				Point3 p(0.0f, 0.0f, 0.0f);
				p = VertList[SegmentList[j].a];
				Addspline->AddKnot(SplineKnot(KTYPE_AUTO,LTYPE_CURVE,
						   p,p,p));

				p = VertList[SegmentList[j].b];
				Addspline->AddKnot(SplineKnot(KTYPE_AUTO,LTYPE_CURVE,
								   p,p,p));

				SegmentList[j].used =1;

				tmp = SegmentList[j];

				while (!done)
					{
					found = -1;
					for (i=0;i<SegmentList.Count();i++)
						{
						if ((!SegmentList[i].used)&(tmp.b == SegmentList[i].a))
							{	
							 found = i;
							 i = SegmentList.Count();
							}
						}
					if (found!=-1)
						{
//Next points or knots are added to the spline by calling AddKnot(). This allows you to add different types of knots and line segments.
//spline->KnotPoint(i)
						p = VertList[SegmentList[found].b];

						Addspline->AddKnot(SplineKnot(KTYPE_AUTO,LTYPE_CURVE,
								   p,p,p));
						SegmentList[found].used =1;
						tmp = SegmentList[found];

						}
						else 
						{
						done = 1;
						}

					}
	
				Addspline->ComputeBezPoints();
				for (i=0;i<Addspline->KnotCount();i++)
					Addspline->SetKnotType(i,KType);
				Addspline->ComputeBezPoints();
				Addspline->SetOpen();

//				Addspline->ComputeBezPoints();

				}
			}


		}

	}
//ashape.UpdateSels();	// Make sure it readies the selection set info
//ashape.InvalidateGeomCache();

			
}

}



void DonutObject::BuildShape(TimeValue t, BezierShape& ashape) {
	// Start the validity interval at forever and whittle it down.
	ivalid = FOREVER;


	for (int i=0;i<100;i++)
		{
		if (SkinNode[i].SplineNode != NULL)
			SkinNode[i].SplineNode->GetNodeTM(t,&ivalid);
		}

//	ivalid = NEVER;

	ashape.NewShape();
	
	BuildSkin(t, ashape);

//	MakeCircle(ashape,radius2);

	ashape.UpdateSels();	// Make sure it readies the selection set info
	ashape.InvalidateGeomCache();
	}

DonutObject::DonutObject() : ShapeObject() 
	{

	ivalid.SetEmpty();	
	SetAFlag(A_OBJ_CREATING);
//	suspendSnap = FALSE;
	pblock = NULL;

//	ReadyInterpParameterBlock();		// Build the interpolations parameter block in SimpleSpline
	MakeRefByID(FOREVER, PBLOCK_REF, CreateParameterBlock(descVer3, PBLOCK_LENGTH, CURRENT_VERSION));
	assert(pblock);
	for (int i=0;i<100;i++)
		{
		SkinNode[i].SplineNode = NULL;	
		SkinControl[i].c = NULL;	
		}
	
 	}

DonutObject::~DonutObject()
	{
	for (int i=0;i<100;i++)
		{
		SkinNode[i].SplineNode = NULL;	
		SkinControl[i].c = NULL;	
		}
	theHold.Suspend();
	DeleteAllRefsFromMe();
	theHold.Resume();

	pblock = NULL;
	}

class DonutObjCreateCallBack: public CreateMouseCallBack {
	DonutObject *ob;
	Point3 p[3];
	IPoint2 sp0;
	Point3 center;
	int createType;
	public:
		int proc( ViewExp *vpt,int msg, int point, int flags, IPoint2 m, Matrix3& mat );
		void SetObj(DonutObject *obj) { ob = obj; }
	};

int DonutObjCreateCallBack::proc(ViewExp *vpt,int msg, int point, int flags, IPoint2 m, Matrix3& mat ) {
	if (msg==MOUSE_POINT||msg==MOUSE_MOVE) {
		switch(point) {
/*
			case 0:
				ob->suspendSnap = TRUE;
				sp0 = m;
				createType = 1;
				p[0] = vpt->SnapPoint(m,m,NULL,SNAP_IN_PLANE);
				mat.SetTrans(p[0]); // Set Node's transform
				ob->pblock->SetValue(PB_RADIUS1,0,0.01f);
				ob->pmapParam->Invalidate();
				break;
			case 1: 
				p[1] = vpt->SnapPoint(m,m,NULL,SNAP_IN_PLANE);
				if ( createType ) {	// radius	
					r = Length(p[1]-p[0]);
					center = p[0];
					}
				else {// diameter
					center = (p[0]+p[1]) / 2.0f;
					r = Length(center-p[0]);
					mat.SetTrans(center);  // Modify Node's transform
					}
				ob->pblock->SetValue(PB_RADIUS1,0,r);
				ob->pmapParam->Invalidate();
				if (msg==MOUSE_POINT) {
					if(Length(m-sp0)<3 || Length(p[1]-p[0])<0.1f) {
						return CREATE_ABORT;
						}
					}
				break;
*/
			case 0:
				p[0] = vpt->SnapPoint(m,m,NULL,SNAP_IN_PLANE);
				mat.SetTrans(p[0]); // Set Node's transform



				ob->created = 1;
				
				EnableWindow(GetDlgItem(ob->hWnd,IDC_ADD),TRUE);
				EnableWindow(GetDlgItem(ob->hWnd,IDC_REMOVE),TRUE);
				EnableWindow(GetDlgItem(ob->hWnd,IDC_UP),TRUE);
				EnableWindow(GetDlgItem(ob->hWnd,IDC_DOWN),TRUE);


				ob->pmapParam->Invalidate();
				return CREATE_STOP;
				break;
			}
		}
	else

	if (msg == MOUSE_ABORT) {
		return CREATE_ABORT;
		}

	ob->ShapeInvalid();
	ob->NotifyDependents(FOREVER, PART_OBJ, REFMSG_CHANGE);

	return TRUE;
	}

static DonutObjCreateCallBack donutCreateCB;

CreateMouseCallBack* DonutObject::GetCreateMouseCallBack() {
	donutCreateCB.SetObj(this);
	return(&donutCreateCB);
	}

RefTargetHandle DonutObject::Clone(RemapDir& remap) {
	DonutObject* newob = new DonutObject();
		// Gotta copy the ShapeObject parts
	CopyBaseData(*this);

	newob->ReplaceReference(PBLOCK_REF,pblock->Clone(remap));	
	newob->ivalid.SetEmpty();
	BaseClone(this, newob, remap);
	return(newob);
	}

BOOL DonutObject::ValidForDisplay(TimeValue t) {
//	float radius1, radius2;
//	pblock->GetValue(PB_RADIUS1, t, radius1, ivalid);
//	pblock->GetValue(PB_RADIUS2, t, radius2, ivalid);
//	return (radius1 == 0.0f && radius2 == 0.0f) ? FALSE : TRUE;
	return TRUE;
	}

ParamDimension *DonutObject::GetParameterDim(int pbIndex) 
	{
/*	switch (pbIndex) {

		case PB_RADIUS1:
		case PB_RADIUS2:

			return stdWorldDim;			
*/
//		default:
			return defaultDim;
//		}
	}

TSTR DonutObject::GetParameterName(int pbIndex) 
	{
	switch (pbIndex) {

		case PB_SPLINETYPE:
			return TSTR(_T("SplineType"));
/*		case PB_RADIUS2:
			return TSTR(GetString(IDS_TH_RADIUS2));
*/
		default:
			return TSTR(_T(""));
		}
	}

Interval DonutObject::ObjectValidity(TimeValue t)
	{		
	Interval valid = FOREVER;
//	valid = GetValidity(t);	
	valid = ShapeObject::ObjectValidity(t);
	for (int i=0;i<100;i++)
		{
		if (SkinNode[i].SplineNode != NULL)
			SkinNode[i].SplineNode->GetNodeTM(t,&ivalid);
		}

	return valid;
	}



ObjectState DonutObject::Eval(TimeValue time) 
	{
	return ObjectState(this);
	}

int DonutObject::NumberOfCurves() {
	UpdateShape(GetCOREInterface()->GetTime());
	return shape.splineCount;
	}


BOOL DonutObject::CurveClosed(TimeValue t, int curve) {
	UpdateShape(t);
	if(curve < 0 || curve >= shape.splineCount)
		assert(0);
	return shape.splines[curve]->Closed() ? TRUE : FALSE;
	}



Point3 DonutObject::InterpCurve3D(TimeValue t, int curve, float param, int ptype) {
	UpdateShape(t);
	if(curve < 0 || curve >= shape.splineCount)
		assert(0);
	return shape.InterpCurve3D(curve, param, ptype);
	}

Point3 DonutObject::TangentCurve3D(TimeValue t, int curve, float param, int ptype) {
	UpdateShape(t);
	if(curve < 0 || curve >= shape.splineCount)
		assert(0);
	return shape.TangentCurve3D(curve, param, ptype);
	}

float DonutObject::LengthOfCurve(TimeValue t, int curve) {
	UpdateShape(t);
	if(curve < 0 || curve >= shape.splineCount)
		assert(0);
	return shape.LengthOfCurve(curve);
	}

int DonutObject::NumberOfPieces(TimeValue t, int curve) {
	UpdateShape(t);
	if(curve < 0 || curve >= shape.splineCount)
		assert(0);
	return shape.splines[curve]->Segments();
	}

Point3 DonutObject::InterpPiece3D(TimeValue t, int curve, int piece, float param, int ptype) {
	UpdateShape(t);
	if(curve < 0 || curve >= shape.splineCount)
		assert(0);
	return shape.InterpPiece3D(curve, piece, param, ptype);
	}

Point3 DonutObject::TangentPiece3D(TimeValue t, int curve, int piece, float param, int ptype) {
	UpdateShape(t);
	if(curve < 0 || curve >= shape.splineCount)
		assert(0);
	return shape.TangentPiece3D(curve, piece, param, ptype);
	}



ShapeHierarchy &DonutObject::OrganizeCurves(TimeValue t, ShapeHierarchy *hier) {
	UpdateShape(t);
	return shape.OrganizeCurves(t, hier);
	}

// Hand back a custom PolyShape representation of this shape!
void DonutObject::MakePolyShape(TimeValue t, PolyShape &shape, int steps, BOOL optimize) {
	UpdateShape(t);
	this->shape.MakePolyShape(shape, steps, optimize);
	}




// Cap this shape
int DonutObject::MakeCap(TimeValue t, MeshCapInfo &capInfo, int capType) {
	UpdateShape(t);
	return shape.MakeCap(t, capInfo, capType);
	}

int DonutObject::MakeCap(TimeValue t, PatchCapInfo &capInfo) {
	UpdateShape(t);
	return shape.MakeCap(t, capInfo);
	}


void DonutObject::UpdateShape(TimeValue t) {
	if ( ivalid.InInterval(t) )
		return;
	BuildShape(t, shape);
	}


void DonutObject::FreeCaches() {
	ivalid.SetEmpty();
	shape.NewShape();
	}




int DonutObject::NumberOfVertices(TimeValue t, int curve) {
	UpdateShape(t);
	if(curve >= shape.splineCount)
		assert(0);
	if(curve >= 0)
		return shape.splines[curve]->KnotCount();
	int verts = 0;
	for(int i = 0; i < shape.splineCount; ++i)
		verts += shape.splines[i]->KnotCount();
	return verts;
	}



int DonutObject::CanConvertToType(Class_ID obtype) {
	if ( obtype == splineShapeClassID ||obtype == genericShapeClassID
        )
        {
		return 1;
		}
	if (Object::CanConvertToType (obtype)) return 1;
	if (CanConvertTriObject (obtype)) return 1;
	return 0;
	}

extern TCHAR *GetString(int id);

void DonutObject::GetCollapseTypes(Tab<Class_ID> &clist,Tab<TSTR*> &nlist)
{
    Object::GetCollapseTypes(clist, nlist);
}

Object* DonutObject::ConvertToType(TimeValue t, Class_ID obtype) {
	if (obtype == splineShapeClassID || obtype == defObjectClassID || obtype == genericShapeClassID) {
		UpdateShape(t);
		SplineShape *bshape = new SplineShape();	
		theHold.Suspend();
		bshape->CopyBaseData(*this);
		theHold.Resume();
		bshape->shape = shape;
		bshape->SetChannelValidity(TOPO_CHAN_NUM,ObjectValidity(t));
		bshape->SetChannelValidity(GEOM_CHAN_NUM,ObjectValidity(t));
		return bshape;
		}

	if (Object::CanConvertToType (obtype)) {
		return Object::ConvertToType (t, obtype);
	}

	return NULL;
	}

void DonutObject::GetDeformBBox(TimeValue t, Box3& box, Matrix3 *tm, BOOL useSel )
	{
	UpdateShape(t);
	box = shape.GetBoundingBox(tm);
	box += ShapeObject::GetBoundingBox(t, tm);
	}

void DonutObject::GetLocalBoundBox(TimeValue t, INode *inode,ViewExp* vpt,  Box3& box ) {
	UpdateShape(t);
	box = shape.GetBoundingBox();
	box += ShapeObject::GetBoundingBox(t);
	}

void DonutObject::GetWorldBoundBox(TimeValue t, INode *inode, ViewExp* vpt, Box3& box )
	{
	Matrix3 mat = inode->GetObjectTM(t);
	UpdateShape(t);
	box = shape.GetBoundingBox();
	box += ShapeObject::GetBoundingBox(t);
	box = box * mat;
	}


// From BaseObject

int DonutObject::HitTest(TimeValue t, INode* inode, int type, int crossing, int flags, IPoint2 *p, ViewExp *vpt) {	
	HitRegion hitRegion;
	GraphicsWindow *gw = vpt->getGW();	
	Material *mtl = gw->getMaterial();
   	
	UpdateShape(t);
	gw->setTransform(inode->GetObjectTM(t));

	MakeHitRegion(hitRegion, type, crossing, 4, p);
	return shape.Select( gw, mtl, &hitRegion, flags & HIT_ABORTONHIT );
	}

void DonutObject::Snap(TimeValue t, INode* inode, SnapInfo *snap, IPoint2 *p, ViewExp *vpt) {

	Matrix3 tm = inode->GetObjectTM(t);	
	GraphicsWindow *gw = vpt->getGW();	
   	
	UpdateShape(t);
	gw->setTransform(tm);

	shape.Snap( gw, snap, p, tm );
	}

#define DISP_NODEFAULTCOLOR (1<<12)
#define COMP_NODEFAULTCOLOR (1<<10)

int DonutObject::Display(TimeValue t, INode *inode, ViewExp *vpt, int flags) {
	if ( !ValidForDisplay(t) )
		return 0;

	GraphicsWindow *gw = vpt->getGW();

   	UpdateShape(t);
	gw->setTransform(inode->GetObjectTM(t));
	
	ShapeObject::Display(t, inode, vpt, flags);

	// If creating, show the vertex ticks
	BOOL ticksSet = FALSE;

	shape.Render( gw, inode->Mtls(),
		(flags&USE_DAMAGE_RECT) ? &vpt->GetDammageRect() : NULL, 
		COMP_ALL | ((flags&DISP_SHOWSUBOBJECT)?COMP_OBJSELECTED:0) |
		((flags&DISP_NODEFAULTCOLOR)?COMP_NODEFAULTCOLOR:0) 
		, inode->NumMtls());

	// Turn off the ticks if we set 'em
	if(ticksSet)
		shape.dispFlags &= ~DISP_VERTTICKS;

	return(0);
	}


// From GeomObject

ObjectHandle DonutObject::CreateTriObjRep(TimeValue t) {
	TriObject *tri = new TriObject;
	BuildMesh(t,tri->GetMesh());
	return(ObjectHandle(tri));
	}

void DonutObject::BuildMesh(TimeValue t, Mesh &mesh) {
	UpdateShape(t);		// Get the shape
	// If the ShapeObject is set to display the generated mesh, use it!
	if(GetDispRenderMesh()) {
		GenerateMesh(t, -1, &mesh);
		return;
		}
	PolyShape pShape;
	MakePolyShape(t, pShape);
	ShapeHierarchy hier;
	pShape.OrganizeCurves(t, &hier);
	// Need to flip the reversed curves in the shape!
	pShape.Reverse(hier.reverse);
	int verts = 0;
	int polys = pShape.numLines;
	for(int poly = 0; poly < polys; ++poly)
		verts += pShape.lines[poly].numPts;
	mesh.setNumVerts(verts);
	verts = 0;
	for(poly = 0; poly < polys; ++poly) {
		PolyLine &line = pShape.lines[poly];
		for(int j = 0; j < line.numPts; ++j) {
			mesh.setVert(verts++, line.pts[j].p);
			}
		}
	MeshCapInfo capInfo;
	pShape.MakeCap(t, capInfo, CAPTYPE_MORPH);
	MeshCapper capper(pShape);
	int vert = 0;
	for(poly = 0; poly < polys; ++poly) {
		PolyLine &line = pShape.lines[poly];
		MeshCapPoly &capline = capper[poly];
		int lverts = line.numPts;
		for(int v = 0; v < lverts; ++v)
			capline.SetVert(v, vert++);			// Gives this vert's location in the mesh!
		}
	capper.CapMesh(mesh, capInfo, FALSE, 1);
	}
