/**********************************************************************
 *<
	FILE: patchgrd.h

	DESCRIPTION:  Defines a Quad Patch Grid Object Class

	CREATED BY: Tom Hudson

	HISTORY: created 22 June 1995

 *>	Copyright (c) 1995, All Rights Reserved.
 **********************************************************************/

#ifndef __PATCH__ 

#define __PATCH__

class QuadPatchCreateCallBack;

#define BMIN_LENGTH		float(0)
#define BMAX_LENGTH		float(1.0E30)
#define BMIN_WIDTH		float(0)
#define BMAX_WIDTH		float(1.0E30)

#define BDEF_DIM		float(0)
#define BDEF_SEGS		1
#define BMIN_SEGS		1
#define BMAX_SEGS		25

class QuadPatchObject: public PatchObject{			   
	friend class QuadPatchCreateCallBack;
	friend BOOL CALLBACK QuadPatchParamDialogProc( HWND hDlg, UINT message, 
		WPARAM wParam, LPARAM lParam );
	
	public:
		// Object parameters		
		IParamBlock *pblock;

		Interval ivalid;
		int creating;

		// Class vars
		static HWND hGridParams;
		static IObjParam *iObjParams;
		static int dlgLSegs;
		static int dlgWSegs;
		static ISpinnerControl *lengthSpin;
		static ISpinnerControl *widthSpin;
		static ISpinnerControl *lsegSpin;
		static ISpinnerControl *wsegSpin;

	//  inherited virtual methods for Reference-management
		RefResult NotifyRefChanged( Interval changeInt, RefTargetHandle hTarget, 
		   PartID& partID, RefMessage message );
		void BuildPatch(TimeValue t,PatchMesh& amesh);
		void UpdatePatch(TimeValue t);
		void UpdateUI(TimeValue t);
		void GetBBox(TimeValue t, Matrix3 &tm, Box3& box);

		QuadPatchObject();
		~QuadPatchObject();

		void SetLength( TimeValue t,float len );
		void SetWidth( TimeValue t,float width );
		void SetWSegs( TimeValue t, int ls );
		void SetLSegs( TimeValue t, int ls );
		float GetLength( TimeValue t, Interval& valid = Interval(0,0) );
		float GetWidth( TimeValue t, Interval& valid = Interval(0,0) );
		int GetWSegs( TimeValue t, Interval& valid = Interval(0,0) );
		int GetLSegs( TimeValue t, Interval& valid = Interval(0,0) );

		void PatchMeshInvalid() { ivalid.SetEmpty(); }

		//  inherited virtual methods:		

		// From BaseObject
		int HitTest(TimeValue t, INode* inode, int type, int crossing, int flags, IPoint2 *p, ViewExp *vpt);
		void Snap(TimeValue t, INode* inode, SnapInfo *snap, IPoint2 *p, ViewExp *vpt);
		int Display(TimeValue t, INode* inode, ViewExp *vpt, int flags);
		CreateMouseCallBack* GetCreateMouseCallBack();
		void BeginEditParams( IObjParam *ip, ULONG flags, Animatable *prev );
		void EndEditParams( IObjParam *ip, ULONG flags, Animatable *next );
		TCHAR *GetObjectName() { return GetResString(IDS_TH_QUADPATCH); }

		// From Object
		ObjectState Eval(TimeValue time);
		void InitNodeName(TSTR& s) { s = GetResString(IDS_TH_QUADPATCH); }		
		Interval ObjectValidity(TimeValue t);
		int CanConvertToType(Class_ID obtype);
		Object* ConvertToType(TimeValue t, Class_ID obtype);
		void GetDeformBBox(TimeValue t, Box3& box, Matrix3 *tm, BOOL useSel );
		
		// From GeomObject
		int IntersectRay(TimeValue t, Ray& r, float& at);
		ObjectHandle CreateTriObjRep(TimeValue t);  // for rendering, also for deformation		
		void GetWorldBoundBox(TimeValue t, INode *mat, ViewExp *vpt, Box3& box );
		void GetLocalBoundBox(TimeValue t, INode *mat, ViewExp *vpt, Box3& box );

		// Animatable methods
		void DeleteThis() { delete this; }
		void FreeCaches(); 
		Class_ID ClassID() { return Class_ID( PATCHGRID_CLASS_ID, 0); }  
		void GetClassName(TSTR& s) { s = TSTR(GetResString(IDS_TH_QUADPATCHOBJECT)); }		
		
		int NumSubs() { return 1; }  
		Animatable* SubAnim(int i) { return pblock; }
		TSTR SubAnimName(int i) { return TSTR(GetResString(IDS_TH_PARAMETERS));}		
		int IsKeyable() { return 1;}
		BOOL BypassTreeView() { return FALSE; }

		// From ref
		RefTargetHandle Clone(RemapDir& remap = NoRemap());
		int NumRefs() {return 1;}
		RefTargetHandle GetReference(int i) {return pblock;}
		void SetReference(int i, RefTargetHandle rtarg) {pblock=(IParamBlock*)rtarg;}

		// IO
		IOResult Save(ISave *isave);
		IOResult Load(ILoad *iload);

		LRESULT CALLBACK TrackViewWinProc( HWND hwnd,  UINT message, 
	            WPARAM wParam,   LPARAM lParam ){return(0);}
	};				


#endif // __PATCH__
