/**********************************************************************
 *<
	FILE: afregion.cpp

	DESCRIPTION:  Affect region modifier

	CREATED BY: Rolf Berteig

	HISTORY: 10/16/96

 *>	Copyright (c) 1994, All Rights Reserved.
 **********************************************************************/

#include "mods.h"
#include "iparamm.h"

#define PBLOCK_REF	0



//--- Parameter map/block descriptors -------------------------------

#define PB_CHANNEL		0


class AFRMod : public Modifier {	
	public:
		IParamBlock *pblock;
		static HWND hParams;



		static IObjParam *ip;
		static IParamMap *pmapParam;
		int channel;


		
		AFRMod();
		~AFRMod();

		// From Animatable
		void DeleteThis() { delete this; }
		void GetClassName(TSTR& s) {s = GetString(IDS_RB_AFRMOD);}  
		virtual Class_ID ClassID() { return Class_ID(9815845,98769);}		
		void BeginEditParams(IObjParam  *ip, ULONG flags,Animatable *prev);
		void EndEditParams(IObjParam *ip,ULONG flags,Animatable *next);		
		RefTargetHandle Clone(RemapDir& remap = NoRemap());
		TCHAR *GetObjectName() {return GetString(IDS_RB_AFRMOD);}

		// From modifier
		ChannelMask ChannelsUsed()  {return PART_GEOM|PART_TOPO|PART_SELECT|PART_SUBSEL_TYPE|PART_TEXMAP|PART_VERTCOLOR;}
		ChannelMask ChannelsChanged() {return TEXMAP_CHANNEL|PART_VERTCOLOR;}
		Class_ID InputType() {return mapObjectClassID;}
		void ModifyObject(TimeValue t, ModContext &mc, ObjectState *os, INode *node);
		Interval LocalValidity(TimeValue t);

		// From BaseObject
		// From BaseObject
		CreateMouseCallBack* GetCreateMouseCallBack() {return NULL;} 
		IParamArray *GetParamBlock() {return pblock;}
		int GetParamBlockIndex(int id) {return id;}

		int NumRefs() {return 1;};
		RefTargetHandle GetReference(int i);
		void SetReference(int i, RefTargetHandle rtarg);

		int NumSubs() {return 1;}
		Animatable* SubAnim(int i) {return GetReference(i);}
		TSTR SubAnimName(int i);

		RefResult NotifyRefChanged( Interval changeInt,RefTargetHandle hTarget, 
		   PartID& partID, RefMessage message);


		IOResult Load(ILoad *iload);
		IOResult Save(ISave *isave);

};

HWND AFRMod::hParams  = NULL;



//--- ClassDescriptor and class vars ---------------------------------

IParamMap       *AFRMod::pmapParam = NULL;
IObjParam       *AFRMod::ip        = NULL;

class AFRClassDesc:public ClassDesc {
	public:
	int 			IsPublic() { return 1; }
	void *			Create(BOOL loading = FALSE) { return new AFRMod; }
	const TCHAR *	ClassName() { return GetString(IDS_RB_AFRMOD); }
	SClass_ID		SuperClassID() { return OSM_CLASS_ID; }
	Class_ID		ClassID() { return Class_ID(9815845,98769); }
	const TCHAR* 	Category() { return GetString(IDS_RB_DEFDEFORMATIONS);}
	};

static AFRClassDesc afrDesc;
extern ClassDesc* GetAFRModDesc() {return &afrDesc;}


//
// Parameters
static int chanIDs[] = {IDC_RADIO1,IDC_RADIO2};

static ParamUIDesc descParam[] = {

	// Channel
	ParamUIDesc(PB_CHANNEL,TYPE_RADIO,chanIDs,2)

	};
#define PARAMDESC_LENGTH	1

static ParamBlockDescID descVer0[] = {
	{ TYPE_INT, NULL, FALSE,  0 }		// Channel
	};
#define PBLOCK_LENGTH	1

#define CURRENT_VERSION	0



//--- Affect region mod methods -------------------------------

AFRMod::AFRMod() 
	{
	MakeRefByID(
		FOREVER, PBLOCK_REF, 
		CreateParameterBlock(
			descVer0, PBLOCK_LENGTH, CURRENT_VERSION));
	
	pblock->SetValue(PB_CHANNEL,0,0);


	}


AFRMod::~AFRMod()
	{
	
	DeleteAllRefsFromMe();
	}


void AFRMod::BeginEditParams(
		IObjParam  *ip, ULONG flags,Animatable *prev)
	{
	this->ip = ip;

	TimeValue t = ip->GetTime();

	pmapParam = CreateCPParamMap(
		descParam,PARAMDESC_LENGTH,
		pblock,
		ip,
		hInstance,
		MAKEINTRESOURCE(IDD_AFRPARAM),
		GetString(IDS_RB_PARAMETERS),
		0);	

	NotifyDependents(Interval(t,t), PART_ALL, REFMSG_BEGIN_EDIT);	
	SetAFlag(A_MOD_BEING_EDITED);

	}

void AFRMod::EndEditParams(
		IObjParam *ip,ULONG flags,Animatable *next)
	{

		// NOTE: This flag must be cleared before sending the REFMSG_END_EDIT
	TimeValue t = ip->GetTime();
	ClearAFlag(A_MOD_BEING_EDITED);

	NotifyDependents(Interval(t,t), PART_ALL, REFMSG_END_EDIT);

	DestroyCPParamMap(pmapParam);
	}

RefTargetHandle AFRMod::Clone(RemapDir& remap)
	{
	AFRMod *mod = new AFRMod();
	mod->ReplaceReference(PBLOCK_REF,pblock->Clone(remap));
	BaseClone(this, mod, remap);
	return mod;
	}



RefTargetHandle AFRMod::GetReference(int i)

	{
	if (i==0)
		return pblock;
	else return NULL;

	}

void AFRMod::SetReference(int i, RefTargetHandle rtarg)
	{
	if (i==0)
		pblock = (IParamBlock*)rtarg;

	}

TSTR AFRMod::SubAnimName(int i)
	{
	return _T("");
	}

RefResult AFRMod::NotifyRefChanged(
		Interval changeInt,RefTargetHandle hTarget, 
		PartID& partID, RefMessage message)
	{
	switch (message) {
		case REFMSG_GET_PARAM_NAME: {
			GetParamName *gpn = (GetParamName*)partID;			
			switch (gpn->index) {
				case PB_CHANNEL: gpn->name = _T("Channel"); break;
				}
			return REF_STOP; 
			}

		}
	return REF_SUCCEED;
	}

IOResult AFRMod::Load(ILoad *iload)
	{
	Modifier::Load(iload);
	IOResult res = IO_OK;
	int NodeID = 0;
	

 	while (IO_OK==(res=iload->OpenChunk())) {
		NodeID = iload->CurChunkID();

		iload->CloseChunk();
		if (res!=IO_OK)  return res;
		}
	return IO_OK;
	}

IOResult AFRMod::Save(ISave *isave)
	{
	Modifier::Save(isave);


	
	return IO_OK;
	}



Interval AFRMod::LocalValidity(TimeValue t)
	{
	Interval valid = FOREVER;
	return valid;
	}






void AFRMod::ModifyObject(
		TimeValue t, ModContext &mc, ObjectState *os, INode *node)
	{
	Interval valid = FOREVER;

//loop through bone nodes to get new interval
	pblock->GetValue(PB_CHANNEL,t,channel,valid);


	if (os->obj->IsSubClassOf(triObjectClassID)) {
		TriObject *tobj = (TriObject*)os->obj;
		Mesh &mesh = tobj->mesh;
		
		int ct = 0;
		if (channel == 0)
		    ct = mesh.numCVerts;
		else ct = mesh.numTVerts;


		int fct = mesh.getNumFaces();
		int vct = mesh.getNumVerts();

//create TVface list
//create TVVert list
//else copy to all mesh
		if (mesh.selLevel != MESH_FACE)
			{
			if (channel == 0)
				{
				mesh.setNumTVerts(vct);
				mesh.setNumTVFaces(fct);
				}
			else
				{
				mesh.setNumVertCol(vct);
				if (mesh.tvFace == NULL)
				mesh.setNumVCFaces(fct);
				}

			ct = vct;

			for (int i = 0; i < mesh.getNumFaces(); i++)
			
				{
				if (channel == 0)
					mesh.tvFace[i].setTVerts(mesh.faces[i].getAllVerts());
					else mesh.vcFace[i].setTVerts(mesh.faces[i].getAllVerts());
				}
//look for texture verts if not there create them
			for (i=0; i<ct; i++) {

// get point
				Point3 uvw = mesh.getVert(i);
				if (channel) 
					 mesh.vertCol[i] = uvw;
				else mesh.tVerts[i] = uvw;
				}

			}
//else copy to just selected faces
		else
			{
			int offset = vct;
			Tab<Point3> Points;
			Tab<int> VIndex;
			Tab<TVFace> Faces;
			for (int i = 0; i < mesh.getNumFaces(); i++)
				{
				if (mesh.faceSel[i] == 1)
					{
					TVFace tv;
					for (int k = 0; k < 3; k++)
						{
						int found = -1;
//loop through vindex see if they already exist
						for (int j = 0; j < VIndex.Count(); j++)
							{
							int index = mesh.faces[i].v[k];
							if (index == VIndex[j])
								{
								found = j;
								j = VIndex.Count();
//								k = 3;
								}
							}
						if (found == -1)
							{
							VIndex.Append(1,&i,1);
							tv.t[k] = VIndex.Count()-1; 
							Point3  p = mesh.verts[mesh.faces[i].v[k]];
							Points.Append(1,&p,1);
							}
						else
							{
							tv.t[k] = found; 
							}
						}
//append face
					Faces.Append(1,&tv,1);
					}

				}

			if (channel == 0)
				{
				mesh.setNumTVerts(vct+VIndex.Count(),TRUE);
				if (mesh.tvFace == NULL)
					mesh.setNumTVFaces(fct);
					
				}
			else
				{
				mesh.setNumVertCol(vct+VIndex.Count(),TRUE);
				if (mesh.vcFace == NULL)
					mesh.setNumVCFaces(fct);
					
				}

			ct = vct;

			int f = 0;
			for (i = 0; i < mesh.getNumFaces(); i++)
			
				{
				if (mesh.faceSel[i] == 1)
					{
					Faces[f].t[0] += vct;
					Faces[f].t[1] += vct;
					Faces[f].t[2] += vct;
					if (channel == 0)
						mesh.tvFace[i] = Faces[f++];
						else mesh.vcFace[i] = Faces[f++];
//						mesh.tvFace[i].setTVerts(mesh.faces[i].getAllVerts());
//						else mesh.vcFace[i].setTVerts(mesh.faces[i].getAllVerts());
					}
				}
//look for texture verts if not there create them
			for (i=0; i<Points.Count(); i++) {

// get point
//				Point3 uvw = mesh.getVert(i);
				Point3 uvw = Points[i];
				if (channel) 
					 mesh.vertCol[i+vct] = uvw;
				else mesh.tVerts[i+vct] = uvw;
				}
			}

		Interval iv = LocalValidity(t);
		iv = iv & os->obj->ChannelValidity(t,GEOM_CHAN_NUM);
		iv = iv & os->obj->ChannelValidity(t,TOPO_CHAN_NUM);

		os->obj->UpdateValidity(TEXMAP_CHAN_NUM,valid);	
		}

	else if (os->obj->IsSubClassOf(patchObjectClassID)) {


		PatchObject *patOb = (PatchObject *)os->obj;
		PatchMesh &mesh  = patOb->patch;
		
		int ct = 0;


		int fct = mesh.getNumPatches();
		int vct = mesh.getNumVerts();

//create TVface list
//create TVVert list
		if (mesh.selLevel != PATCH_PATCH)
			{
			mesh.setNumTVertsChannel(channel,vct);
			mesh.setNumTVPatchesChannel(channel,fct);
			ct = vct;

			for (int i = 0; i < mesh.getNumPatches(); i++)
			
				{
				int a,b,c,d;
				a  = mesh.patches[i].v[0];
				b  = mesh.patches[i].v[1];
				c  = mesh.patches[i].v[2];
				d  = mesh.patches[i].v[3];
				mesh.getTVPatchChannel(channel,i).setTVerts(a,b,c,d);
				}
//look for texture verts if not there create them
			for (i=0; i<ct; i++) {

// get point
				PatchVert pv = mesh.getVert(i);;
				Point3 uvw = pv.p;
				mesh.setTVertChannel(channel,i,uvw);
				}
			}
		else
//else copy to just selected patches
			{
			int offset = vct;
			Tab<Point3> Points;
			Tab<int> VIndex;
			Tab<TVPatch> Faces;
			for (int i = 0; i < mesh.getNumPatches(); i++)
				{
				if (mesh.patchSel[i] == 1)
					{
					TVPatch tv;
					int pcount = 3;
					if (mesh.patches[i].type == PATCH_QUAD) pcount =4;
					for (int k = 0; k < pcount; k++)
						{
						int found = -1;
//loop through vindex see if they already exist
						for (int j = 0; j < VIndex.Count(); j++)
							{
							int index = mesh.patches[i].v[k];
							if (index == VIndex[j])
								{
								found = j;
								j = VIndex.Count();
//								k = 4;
								}
							}
						if (found == -1)
							{
							VIndex.Append(1,&i,1);
							tv.tv[k] = VIndex.Count()-1; 
							Point3  p = mesh.verts[mesh.patches[i].v[k]].p;
							Points.Append(1,&p,1);
							}
						else
							{
							tv.tv[k] = found; 
							}
						}
//append face
					Faces.Append(1,&tv,1);
					}

				}

			mesh.setNumTVertsChannel(channel,vct+VIndex.Count());
			if (mesh.tvPatches[channel] == NULL)
				mesh.setNumTVPatchesChannel(channel,fct);
/*
			if (channel == 0)
				{

				mesh.setNumTVerts(vct+VIndex.Count(),TRUE);

				if (mesh.tvFace == NULL)
					mesh.setNumTVFaces(fct);
					
				}
			else
				{
				mesh.setNumVertCol(vct+VIndex.Count(),TRUE);
				if (mesh.vcFace == NULL)
					mesh.setNumVCFaces(fct);
					
				}
*/

			ct = vct;

			int f = 0;
			TVPatch *tvf = mesh.tvPatches[channel];
			for (i = 0; i < mesh.getNumPatches(); i++)
			
				{
				if (mesh.patchSel[i] == 1)
					{
					Faces[f].tv[0] += vct;
					Faces[f].tv[1] += vct;
					Faces[f].tv[2] += vct;
					Faces[f].tv[3] += vct;
					tvf[i] = Faces[f++];
//					if (channel == 0)
//						mesh.tvPatch[i] = Faces[f++];
//						else mesh.tvPatch[i] = Faces[f++];
					}
				}
//look for texture verts if not there create them
			PatchTVert *tvp = mesh.tVerts[channel];

			for (i=0; i<Points.Count(); i++) {

// get point
//				Point3 uvw = mesh.getVert(i);
				Point3 uvw = Points[i];
				tvp[i+vct] = uvw;
//				if (channel) 
//					 mesh.vertCol[i+vct] = uvw;
//				else mesh.tVerts[i+vct] = uvw;
				}
			}




		Interval iv = LocalValidity(t);
		iv = iv & os->obj->ChannelValidity(t,GEOM_CHAN_NUM);
		iv = iv & os->obj->ChannelValidity(t,TOPO_CHAN_NUM);

		os->obj->UpdateValidity(TEXMAP_CHAN_NUM,valid);	

		}

	}
	
